#version 330 compatibility




/*
 _______ _________ _______  _______  _ 
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _ 
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the LICENSE.txt contained in the root directory of this shaderpack!

*/


#include "lib/Uniforms.inc"
#include "lib/Common.inc"


const bool colortex6MipmapEnabled = false;


in vec4 texcoord;

in vec3 lightVector;
in vec3 worldLightVector;
in vec3 worldSunVector;

in float timeMidnight;

in vec3 colorSunlight;
in vec3 colorSkylight;
in vec3 colorSkyUp;
in vec3 colorTorchlight;

in vec4 skySHR;
in vec4 skySHG;
in vec4 skySHB;

#include "lib/GBufferData.inc"


// vec4 GetViewPosition(in vec2 coord, in float depth) 
// {	
// 	vec4 tcoord = vec4(coord.xy, 0.0, 0.0);

// 	vec4 fragposition = gbufferProjectionInverse * vec4(tcoord.s * 2.0f - 1.0f, tcoord.t * 2.0f - 1.0f, 2.0f * depth - 1.0f, 1.0f);
// 		 fragposition /= fragposition.w;

	
// 	return fragposition;
// }





#include "lib/Materials.inc"


 int v(float v)
 {
   return int(floor(v));
 }
 int t(int f)
 {
   return f-v(mod(float(f),2.))-0;
 }
 int d(int f)
 {
   return f-v(mod(float(f),2.))-1;
 }
 int d()
 {
   ivec2 s=ivec2(viewWidth,viewHeight);
   int f=s.x*s.y;
   return t(v(floor(pow(float(f),.333333))));
 }
 int t()
 {
   ivec2 s=ivec2(2048,2048);
   int f=s.x*s.y;
   return d(v(floor(pow(float(f),.333333))));
 }
 vec3 e(vec2 v)
 {
   ivec2 s=ivec2(viewWidth,viewHeight);
   int f=s.x*s.y,y=d();
   ivec2 i=ivec2(v.x*s.x,v.y*s.y);
   float z=float(i.y/y),r=float(int(i.x+mod(s.x*z,y))/y);
   r+=floor(s.x*z/y);
   vec3 m=vec3(0.,0.,r);
   m.x=mod(i.x+mod(s.x*z,y),y);
   m.y=mod(i.y,y);
   m.xyz=floor(m.xyz);
   m/=y;
   m.xyz=m.xzy;
   return m;
 }
 vec2 w(vec3 s)
 {
   ivec2 v=ivec2(viewWidth,viewHeight);
   int z=d();
   vec3 f=s.xzy*z;
   f=floor(f+1e-05);
   float x=f.z;
   vec2 r;
   r.x=mod(f.x+x*z,v.x);
   float i=f.x+x*z;
   r.y=f.y+floor(i/v.x)*z;
   r+=.5;
   r/=v;
   return r;
 }
 vec3 r(vec2 v)
 {
   vec2 f=v;
   f.xy/=.5;
   ivec2 s=ivec2(2048,2048);
   int z=s.x*s.y,y=t();
   ivec2 i=ivec2(f.x*s.x,f.y*s.y);
   float x=float(i.y/y),r=float(int(i.x+mod(s.x*x,y))/y);
   r+=floor(s.x*x/y);
   vec3 m=vec3(0.,0.,r);
   m.x=mod(i.x+mod(s.x*x,y),y);
   m.y=mod(i.y,y);
   m.xyz=floor(m.xyz);
   m/=y;
   m.xyz=m.xzy;
   return m;
 }
 vec2 d(vec3 v,int z)
 {
   v=clamp(v,vec3(0.),vec3(1.));
   ivec2 f=ivec2(2048,2048);
   vec3 s=v.xzy*z;
   s=floor(s+1e-05);
   float x=s.z;
   vec2 r;
   r.x=mod(s.x+x*z,f.x);
   float i=s.x+x*z;
   r.y=s.y+floor(i/f.x)*z;
   r+=.5;
   r/=f;
   r.xy*=.5;
   return r;
 }
 vec3 e(vec3 v,int y)
 {
   return v*=1./y,v=v+vec3(.5),v=clamp(v,vec3(0.),vec3(1.)),v;
 }
 vec3 r(vec3 v,int y)
 {
   return v*=1./y,v=v+vec3(.5),v;
 }
 vec3 f(vec3 v)
 {
   int s=t();
   v=v-vec3(.5);
   v*=s;
   return v;
 }
 vec3 x(vec3 v)
 {
   int y=d();
   v*=1./y;
   v=v+vec3(.5);
   v=clamp(v,vec3(0.),vec3(1.));
   return v;
 }
 vec3 p(vec3 v)
 {
   int s=d();
   v=v-vec3(.5);
   v*=s;
   return v;
 }
 vec3 e()
 {
   vec3 v=cameraPosition.xyz+.5,f=previousCameraPosition.xyz+.5,y=floor(v-.0001),z=floor(f-.0001);
   return y-z;
 }
 vec3 s(vec3 v)
 {
   vec4 f=vec4(v,1.);
   f=shadowModelView*f;
   f=shadowProjection*f;
   f/=f.w;
   float x=sqrt(f.x*f.x+f.y*f.y),y=1.f-SHADOW_MAP_BIAS+x*SHADOW_MAP_BIAS;
   f.xy*=.95f/y;
   f.z=mix(f.z,.5,.8);
   f=f*.5f+.5f;
   f.xy*=.5;
   f.xy+=.5;
   return f.xyz;
 }
 vec3 d(vec3 v,vec3 f,vec3 y,vec3 z,int t)
 {
   if(rainStrength>.99)
     return vec3(0.);
   v+=1.;
   v-=Fract01(cameraPosition+.5);
   vec3 i=s(v);
   float x=.5;
   vec3 r=vec3(1.)*shadow2DLod(shadowtex0,vec3(i.xy,i.z-.0006*x),0).x;
   r*=saturate(dot(f,y));
   {
     vec4 m=texture2DLod(shadowcolor1,i.xy-vec2(0.,.5),4);
     float h=abs(m.x*256.-(v.y+cameraPosition.y)),p=GetCausticsComposite(v,f,h),w=shadow2DLod(shadowtex0,vec3(i.xy-vec2(0.,.5),i.z+1e-06),4).x;
     r=mix(r,r*p,1.-w);
   }
   r=TintUnderwaterDepth(r);
   return r*(1.-rainStrength);
 }
 vec3 e(vec3 v,vec3 i,vec3 y,vec3 z,int t)
 {
   if(rainStrength>.99)
     return vec3(0.);
   vec3 x=f(v),r=s(x+y*.99);
   float m=.5;
   vec3 e=vec3(1.)*shadow2DLod(shadowtex0,vec3(r.xy,r.z-.0006*m),3).x;
   e*=saturate(dot(i,y));
   e=TintUnderwaterDepth(e);
   return e*(1.-rainStrength);
 }
 vec3 f(vec3 v,vec3 f,vec3 y,vec3 z,int t)
 {
   if(rainStrength>.99)
     return vec3(0.);
   v+=1.;
   v-=Fract01(cameraPosition+.5);
   vec3 i=s(v);
   float x=.5;
   vec3 r=vec3(1.)*shadow2DLod(shadowtex0,vec3(i.xy,i.z-.0006*x),2).x;
   r*=saturate(dot(f,y));
   r=TintUnderwaterDepth(r);
   return r*(1.-rainStrength);
 }struct GITemporalData2{float cNuyPQlxuC;float ZFucbkcOTp;float vfyvrzqkzI;float xSSGSkZnBe;vec3 MXlHQOttjo;};
 vec4 h(GITemporalData2 v)
 {
   vec4 f;
   v.MXlHQOttjo=max(vec3(0.),v.MXlHQOttjo);
   f.x=v.cNuyPQlxuC;
   v.MXlHQOttjo=pow(v.MXlHQOttjo,vec3(.25));
   f.y=PackTwo16BitTo32Bit(v.MXlHQOttjo.x,v.vfyvrzqkzI);
   f.z=PackTwo16BitTo32Bit(v.MXlHQOttjo.y,v.xSSGSkZnBe);
   f.w=PackTwo16BitTo32Bit(v.MXlHQOttjo.z,v.ZFucbkcOTp);
   return f;
 }
 GITemporalData2 n(vec4 v)
 {
   GITemporalData2 f;
   vec2 s=UnpackTwo16BitFrom32Bit(v.y),i=UnpackTwo16BitFrom32Bit(v.z),m=UnpackTwo16BitFrom32Bit(v.w);
   f.cNuyPQlxuC=v.x;
   f.vfyvrzqkzI=s.y;
   f.xSSGSkZnBe=i.y;
   f.ZFucbkcOTp=m.y;
   f.MXlHQOttjo=pow(vec3(s.x,i.x,m.x),vec3(4.));
   return f;
 }
 GITemporalData2 a(vec2 v)
 {
   vec2 f=1./vec2(viewWidth,viewHeight),y=vec2(viewWidth,viewHeight);
   v=(floor(v*y)+.5)*f;
   return n(texture2DLod(colortex5,v,0));
 }
 float a(float v,float y)
 {
   float f=1.;
   #ifdef FULL_RT_REFLECTIONS
   f=clamp(pow(v,.125)+y,0.,1.);
   #else
   f=clamp(v*10.-7.,0.,1.);
   #endif
   return f;
 }
 void a(inout float v,inout float f,float s,float y,vec3 i,float t)
 {
   v*=mix(2.4,2.4,y);
   float x=dot(i,vec3(1.));
   f*=1.-pow(y,.4);
   f/=s*.1+2e-06;
   f*=4.;
   f*=.6;
   float r=s/(x+1e-07)*.2+4e-08;
   r=min(r,1.);
   r=mix(r,1.,pow(y,.25));
   if(t<.12)
     f=0.;
 }
 float a(vec3 v,vec3 y,float f)
 {
   float r=dot(abs(v-y),vec3(.3333));
   r*=f;
   r*=.18;
   return r;
 }
 void d(inout vec3 v,vec2 y,vec3 f)
 {}
 float f(float v,float f)
 {
   return v/(f*20.01+1.);
 }
 float h(float v,float y)
 {
   return 1./(v*(1.-y)+y);
 }
 void a(inout vec3 v,in vec3 f,in vec3 y,vec3 s,float z)
 {
   float r=length(f);
   #ifdef FADE_TO_ATMOSPHERE
   float i=length(f)/far;
   i=pow(i,6.)*.07+pow(i,2.)*.003;
   #else
   float x=length(f)/300.;
   x=pow(x,3.)*.002;
   #endif
   x*=pow(eyeBrightnessSmooth.y/240.f,6.f);
   x=clamp(x,0.,.03);
   x/=saturate(s.y)*2.+1.;
   vec3 e=vec3(.2,.45,1.);
   v*=exp(-x*e*100.67);
   v+=AtmosphericScattering(normalize(s),worldSunVector,1.,x)*.9*mix(z,1.,.5)*mix(1.,.35,wetness)*.1;
 }
 void h(inout vec3 v,in vec3 f,in vec3 y,vec3 z,float t)
 {
   float r=length(f);
   r*=pow(eyeBrightnessSmooth.y/240.f,6.f);
   r*=rainStrength;
   float s=pow(exp(-r*1e-05),4.);
   vec3 i=vec3(dot(colorSkyUp,vec3(1.)))*.001;
   v=mix(i,v,vec3(s));
 }
 vec4 m(vec2 v)
 {
   vec2 f=vec2(v.x,(v.y-floor(mod(FRAME_TIME*60.f,60.f)))/60.f);
   return texture2DLod(colortex4,f.xy,0);
 }
 float m(vec3 v,float f)
 {
   vec3 r=v.xyz+cameraPosition.xyz,s=refract(worldLightVector,vec3(0.,1.,0.),.750188);
   r+=s*((v.y+cameraPosition.y)/s.y);
   vec4 i=m(mod(r.xz/4.,vec2(1.)))*13.;
   float x=pow(f/2.,.5),y=pow(i.x,saturate(x*.5+.5));
   y=mix(y,i.y,saturate(x-1.));
   y=mix(y,i.z,saturate(x-2.));
   y=mix(y,i.w,saturate(x-3.));
   return y;
 }
 float n(float v,float f)
 {
   return exp(-pow(v/(.9*f),2.));
 }
 float p(vec3 v,vec3 y)
 {
   return dot(abs(v-y),vec3(.3333));
 }
 vec3 G(vec2 v)
 {
   vec2 f=vec2(v.xy*vec2(viewWidth,viewHeight))/64.;
   const vec2 y[16]=vec2[16](vec2(-1,-1),vec2(0,-.333333),vec2(-.5,.333333),vec2(.5,-.777778),vec2(-.75,-.111111),vec2(.25,.555556),vec2(-.25,-.555556),vec2(.75,.111111),vec2(-.875,.777778),vec2(.125,-.925926),vec2(-.375,-.259259),vec2(.625,.407407),vec2(-.625,-.703704),vec2(.375,-.037037),vec2(-.125,.62963),vec2(.875,-.481482));
   if(v.x<2./viewWidth||v.x>1.-2./viewWidth||v.y<2./viewHeight||v.y>1.-2./viewHeight)
     ;
   f=(floor(f*64.)+.5)/64.;
   vec3 r=texture2D(noisetex,f).xyz,i=vec3(sqrt(.2),sqrt(2.),1.61803);
   r=mod(r+vec3(i)*mod(frameCounter,64.f),vec3(1.));
   return r;
 }
 vec3 G(float v,float f,float y,vec3 i)
 {
   vec3 r;
   r.x=y*cos(v);
   r.y=y*sin(v);
   r.z=f;
   vec3 x=abs(i.y)<.999?vec3(0,0,1):vec3(1,0,0),s=normalize(cross(i,vec3(0.,1.,1.))),z=cross(s,i);
   return s*r.x+z*r.y+i*r.z;
 }
 vec3 G(vec2 v,float f,vec3 y)
 {
   float i=2*3.14159*v.x,z=sqrt((1-v.y)/(1+(f*f-1)*v.y)),x=sqrt(1-z*z);
   return G(i,z,x,y);
 }
 float c(float v)
 {
   return 2./(v*v+1e-07)-2.;
 }
 vec3 c(in vec2 v,in float f,in vec3 y)
 {
   float i=c(f),s=2*3.14159*v.x,z=pow(v.y,1.f/(i+1.f)),x=sqrt(1-z*z);
   return G(s,z,x,y);
 }
 float g(vec2 v)
 {
   return texture2DLod(colortex3,v,0).w;
 }
 vec4 G(sampler2D v,float y,bool i,float s,float z,float x,float t)
 {
   GBufferData r=GetGBufferData();
   GBufferDataTransparent m=GetGBufferDataTransparent();
   bool e=m.depth<r.depth;
   if(e)
     r.normal=m.normal,r.smoothness=m.smoothness,r.metalness=0.,r.mcLightmap=m.mcLightmap,r.depth=m.depth;
   vec4 d=GetViewPosition(texcoord.xy,r.depth),w=gbufferModelViewInverse*vec4(d.xyz,1.),c=gbufferModelViewInverse*vec4(d.xyz,0.);
   vec3 h=normalize(d.xyz),o=normalize(c.xyz),l=normalize((gbufferModelViewInverse*vec4(r.normal,0.)).xyz);
   float n=GetDepthLinear(texcoord.xy),T=1.-r.smoothness,S=T*T,b=a(r.smoothness,r.metalness);
   int D=0;
   vec4 F=texture2DLod(colortex6,texcoord.xy,D);
   float M=Luminance(F.xyz);
   if(b<.001)
     return F;
   float I=y*.9;
   I*=min(S*15.,1.1);
   I*=mix(F.w,1.,t);
   vec2 C=vec2(0.);
   if(i)
     {
       vec2 P=G(texcoord.xy).xy*.99+.005;
       C=P-.5;
     }
   float P=0.,u=1.1,L=f(s,r.totalTexGrad)/(S+.0001),B=f(z,r.totalTexGrad);
   vec4 U=vec4(0.),H=vec4(0.);
   float W=0.;
   vec4 Z=vec4(vec3(x),1.);
   Z.xyz=vec3(.5);
   Z.xyz*=F.w*.95+.05;
   float k=r.smoothness;
   int O=0;
   for(int V=-1;V<=1;V++)
     {
       for(int Q=-1;Q<=1;Q++)
         {
           vec2 E=(vec2(V,Q)+C)/vec2(viewWidth,viewHeight)*I,A=texcoord.xy+E.xy;
           float j=length(E*vec2(viewWidth,viewHeight));
           A=clamp(A,4./vec2(viewWidth,viewHeight),1.-4./vec2(viewWidth,viewHeight));
           vec4 X=texture2DLod(colortex6,A,D);
           vec3 q=GetNormals(A);
           float N=GetDepthLinear(A),R=pow(saturate(dot(r.normal,q)),L),Y=exp(-(abs(N-n)*u)),K=exp(-(p(X.xyz,F.xyz)*P)),J=exp(-abs(k-g(A))*B),ab=R*Y*K*J;
           U+=vec4(pow(length(X.xyz),Z.x)*normalize(X.xyz+1e-05),X.w)*ab;
           W+=ab;
           H+=X;
           O++;
         }
     }
   U/=W+.0001;
   U.xyz=pow(length(U.xyz),1./Z.x)*normalize(U.xyz+1e-06);
   vec4 X=U;
   if(W<.001)
     X=F;
   return X;
 }
 void main()
 {
   GBufferData v=GetGBufferData();
   GBufferDataTransparent f=GetGBufferDataTransparent();
   MaterialMask y=CalculateMasks(v.materialID),i=CalculateMasks(f.materialID);
   bool s=f.depth<v.depth;
   if(s)
     v.normal=f.normal,v.smoothness=f.smoothness,v.metalness=0.,v.mcLightmap=f.mcLightmap,v.depth=f.depth,i.sky=0.;
   vec4 r=GetViewPosition(texcoord.xy,v.depth),x=gbufferModelViewInverse*vec4(r.xyz,1.),m=gbufferModelViewInverse*vec4(r.xyz,0.);
   vec3 z=normalize(r.xyz),p=normalize(m.xyz),l=normalize((gbufferModelViewInverse*vec4(v.normal,0.)).xyz);
   float e=ExpToLinearDepth(v.depth),c=1.-v.smoothness,w=c*c,o=a(v.smoothness,v.metalness);
   int t=0;
   vec4 G=texture2DLod(colortex6,texcoord.xy,t),d=G;
   float n=1.-v.smoothness,P=n*n;
   vec3 A=l,D=-p,X=normalize(reflect(-D,A)+A*P),L=normalize(D+X);
   float F=saturate(dot(A,X)),S=saturate(dot(A,D)),b=saturate(dot(A,L)),T=saturate(dot(X,L)),C=v.metalness*.98+.02,I=pow(1.-T,5.),Y=C+(1.-C)*I,u=P/2.,J=h(F,u)*h(S+.8,u),U=F*Y*J;
   d.xyz*=mix(vec3(1.),v.albedo.xyz,vec3(v.metalness));
   U=mix(U,1.,v.metalness);
   if(v.depth>.99999)
     U=0.;
   if(i.water>.5&&isEyeInWater>0)
     {
       if(refract(D,A,1.3333)==0.)
         U=1.;
       else
          U=0.;
     }
   U*=a(v.smoothness,v.metalness);
   vec4 Z=texture2DLod(colortex3,texcoord.xy,0);
   vec3 g=pow(Z.xyz,vec3(2.2)),V=g;
   V*=100.;
   V+=g*v.metalness;
   UnderwaterFog(V,length(m.xyz),p,colorSkyUp,colorSunlight);
   V=mix(V,d.xyz,vec3(U));
   if(i.sky<.5&&!s&&isEyeInWater<1)
     a(V,r.xyz,z.xyz,p.xyz,1.);
   h(V,r.xyz,z.xyz,p.xyz,1.);
   {
     if(isEyeInWater>0)
       {
         float M=BlueNoiseTemporal(texcoord.xy).x,E=20.;
         vec3 W=vec3(0.),B=(gbufferModelViewInverse*vec4(0.,0.,0.,1.)).xyz;
         for(int Q=0;Q<10;Q++)
           {
             float O=float(Q+M)/float(10);
             vec3 k=p.xyz*E*O+B;
             if(length(m.xyz)<length(k-B))
               {
                 break;
               }
             float q,H;
             vec3 N=WorldPosToShadowProjPos(k.xyz,q,H);
             float R=shadow2DLod(shadowtex0,vec3(N.xy,N.z+1e-06),3).x,K=abs(texture2DLod(shadowcolor1,N.xy-vec2(0.,.5),4).x*256.-(k.y+cameraPosition.y)),j=GetCausticsComposite(k,worldLightVector,K),ac=shadow2DLod(shadowtex0,vec3(N.xy-vec2(0.,.5),N.z+1e-06),4).x;
             R=mix(R,R*j,1.-ac);
             W+=R*exp(-GetWaterAbsorption()*(E*O))*exp(-GetWaterAbsorption()*K);
           }
         float R=dot(refract(worldLightVector,vec3(0.,-1.,0.),.750019),p.xyz),K=R*R,H=PhaseMie(.8,R,K);
         V+=TintUnderwaterDepth(W*colorSunlight*GetWaterFogColor()*.075*H);
       }
   }
   V/=100.;
   V*=exp(-e*blindness);
   V=pow(V.xyz,vec3(.454545));
   gl_FragData[0]=vec4(V,Z.w);
 };





/* DRAWBUFFERS:3 */
